<div class="applications-container">
    <div class="page-header">
        <div class="d-flex justify-content-center">
            <h2>Мои заявки</h2>
        </div>
        <p>Здесь отображаются все ваши заявки на туры выходного дня</p>
    </div>

    <?php use yii\helpers\Url;

    if (empty($applications)): ?>
        <div class="no-applications">
            <p>У вас пока нет заявок на туры</p>
            <p>Отправьте первую заявку и начните своё путешествие!</p>
        </div>
    <?php else: ?>
        <?php foreach ($applications as $application): ?>
            <div class="application-card">
                <p>Место тура: <?= htmlspecialchars($application->tours->name); ?></p>
                <p>Дата тура: <?= htmlspecialchars($application->date_tour); ?></p>
                <p>Кол-во участников: <?= htmlspecialchars($application->count_people); ?></p>
                <p><?= htmlspecialchars($application->dop); ?></p>
                <p>Комментарий: <?= htmlspecialchars($application->comment); ?></p>
                <p>Способ оплаты: <?= [0 => '💳 Оплата банковской картой', 1 => '💵 Наличными'][$application->payment_method] ?? '❓ Неизвестно' ?></p>
                <p>Статус заявки: <?= htmlspecialchars($application->status); ?></p>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>

    <div class="btn-container">
        <a href="<?= Url::toRoute(['site/application']); ?>" class="new-application-btn">
            Отправить новую заявку
        </a>
    </div>
