<?php

/** @var yii\web\View $this */

$this->title = 'Туры выходного дня';
?>

<div class="site-index">

    <?php
    use yii\helpers\Url;
    use yii\helpers\Html;
    ?>

    <!-- Блок 1: Описание, преимущества, видео-отчеты -->
    <div class="features-block">
        <div class="container">
            <h2 class="features-title">Туры выходного дня</h2>
            <p class="features-subtitle">Описание, преимущества, видео-отчеты</p>

            <div class="features-grid">
                <div class="feature-item">
                    <div class="feature-icon">🏔</div>
                    <h3 class="feature-title">Уникальные маршруты</h3>
                    <p class="feature-text">Посетите самые красивые места вашего региона с опытными гидами</p>
                </div>

                <div class="feature-item">
                    <div class="feature-icon">🌟</div>
                    <h3 class="feature-title">Преимущества</h3>
                    <p class="feature-text">Комфортные условия, безопасность, доступные цены и отличные впечатления</p>
                </div>

                <div class="feature-item">
                    <div class="feature-icon">🎥</div>
                    <h3 class="feature-title">Видео-отчеты</h3>
                    <p class="feature-text">Смотрите реальные видео с наших туров от участников</p>
                </div>

                <div class="feature-item">
                    <div class="feature-icon">👍</div>
                    <h3 class="feature-title">Гарантии</h3>
                    <p class="feature-text">100% возврат средств при отмене за 3 дня до начала тура</p>
                </div>
            </div>
        </div>
    </div>

<div class="d-flex justify-content-center h-100">
    <h3>Каталог туров</h3>
</div>
    <div class="tours-container">
        <?php foreach ($ts as $t): ?>
            <div class="tour-card">
                <h3><?= htmlspecialchars($t->name); ?></h3>

                <div class="image-container">
                    <?= Html::img("@web/images/{$t->img}", [
                        'alt' => 'Тур: ' . htmlspecialchars($t->name),
                        'loading' => 'lazy',
                        'class' => 'tour-image'
                    ]) ?>
                </div>
                <div class="tour-content">
                    <p class="tour-description"><?= htmlspecialchars($t->description); ?></p>
                    <p class="tour-date">Дата создания: <?= htmlspecialchars($t->date); ?></p>
                    <p class="tour-price">Цена: <?= htmlspecialchars($t->price); ?> рублей</p>

                    <a class="btn btn-primary booking-btn" href="<?= Url::toRoute(['site/application']); ?>">Забронировать</a>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <!-- Блок 2: Услуги и дополнительные опции -->
    <div class="services-block">
        <div class="container">
            <h2 class="services-title">Услуги и дополнительные опции</h2>
            <p class="services-subtitle">Трансфер, экскурсии, питание</p>

            <div class="services-grid">
                <div class="service-item">
                    <div class="service-icon">🚗</div>
                    <h3 class="service-title">Трансфер</h3>
                    <p class="service-text">Комфортабельный транспорт от места сбора до места назначения и обратно</p>
                </div>

                <div class="service-item">
                    <div class="service-icon">🗣️</div>
                    <h3 class="service-title">Экскурсии</h3>
                    <p class="service-text">Профессиональные экскурсоводы с интересными рассказами и историями</p>
                </div>

                <div class="service-item">
                    <div class="service-icon">🍽️</div>
                    <h3 class="service-title">Питание</h3>
                    <p class="service-text">Вкусное и разнообразное питание во время всего тура</p>
                </div>

                <div class="service-item">
                    <div class="service-icon">🏕️</div>
                    <h3 class="service-title">Снаряжение</h3>
                    <p class="service-text">Аренда необходимого туристического снаряжения</p>
                </div>
            </div>
        </div>
    </div>

</div>

<style>
    /* Блок 1: Описание, преимущества, видео-отчеты */
    .features-block {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 80px 20px;
        margin-bottom: 50px;
    }

    .container {
        max-width: 1200px;
        margin: 0 auto;
    }

    .features-title {
        text-align: center;
        font-size: 2.5rem;
        margin-bottom: 10px;
        font-weight: 700;
    }

    .features-subtitle {
        text-align: center;
        font-size: 1.2rem;
        margin-bottom: 50px;
        opacity: 0.9;
    }

    .features-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 30px;
    }

    .feature-item {
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(10px);
        border-radius: 20px;
        padding: 30px;
        text-align: center;
        transition: transform 0.3s ease;
    }

    .feature-item:hover {
        transform: translateY(-10px);
        background: rgba(255, 255, 255, 0.15);
    }

    .feature-icon {
        font-size: 50px;
        margin-bottom: 20px;
    }

    .feature-title {
        font-size: 1.3rem;
        margin-bottom: 15px;
        font-weight: 600;
    }

    .feature-text {
        font-size: 1rem;
        line-height: 1.5;
        opacity: 0.9;
    }

    /* Блок с турами */
    .tours-container {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
        gap: 30px;
        padding: 30px 20px;
        max-width: 1200px;
        margin: 0 auto;
        font-family: Arial, sans-serif;
        margin-bottom: 50px;
    }

    /* Карточка тура */
    .tour-card {
        background: white;
        border-radius: 15px;
        overflow: hidden;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        display: flex;
        flex-direction: column;
        height: 100%;
    }

    .tour-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0,0,0,0.15);
    }

    /* Заголовок карточки */
    .tour-card h3 {
        margin: 0;
        padding: 20px;
        background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
        color: white;
        font-size: 1.3rem;
        font-weight: 600;
        text-align: center;
        min-height: 70px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    /* Изображение тура */
    .image-container {
        width: 100%;
        height: 200px;
        overflow: hidden;
        position: relative;
    }

    .tour-card img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.5s ease;
    }

    .tour-card:hover img {
        transform: scale(1.05);
    }

    /* Контент карточки */
    .tour-content {
        padding: 20px;
        flex-grow: 1;
        display: flex;
        flex-direction: column;
    }

    /* Описание тура */
    .tour-description {
        margin: 0 0 20px 0;
        color: #555;
        line-height: 1.5;
        font-size: 14px;
        flex-grow: 1;
    }

    /* Дата */
    .tour-date {
        margin: 10px 0;
        padding: 12px 15px;
        background: #f8f9fa;
        border-radius: 8px;
        font-size: 14px;
    }

    /* Цена */
    .tour-price {
        margin: 10px 0 20px 0;
        padding: 15px;
        background: #e8f5e9;
        border-radius: 8px;
        text-align: center;
        border-left: 4px solid #4CAF50;
        font-weight: bold;
        color: #2e7d32;
        font-size: 1.2rem;
    }

    /* Кнопка бронирования */
    .booking-btn {
        display: block;
        padding: 15px;
        background: linear-gradient(135deg, #ff9800 0%, #f57c00 100%);
        color: white;
        text-decoration: none;
        border-radius: 8px;
        text-align: center;
        font-weight: 700;
        font-size: 16px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        margin-top: auto;
    }

    .booking-btn:hover {
        background: linear-gradient(135deg, #f57c00 0%, #e65100 100%);
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(245, 124, 0, 0.3);
        color: white;
    }

    /* Блок 2: Услуги и дополнительные опции */
    .services-block {
        background: linear-gradient(135deg, #00b09b 0%, #96c93d 100%);
        color: white;
        padding: 80px 20px;
    }

    .services-title {
        text-align: center;
        font-size: 2.5rem;
        margin-bottom: 10px;
        font-weight: 700;
    }

    .services-subtitle {
        text-align: center;
        font-size: 1.2rem;
        margin-bottom: 50px;
        opacity: 0.9;
    }

    .services-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 30px;
    }

    .service-item {
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(10px);
        border-radius: 20px;
        padding: 30px;
        text-align: center;
        transition: transform 0.3s ease;
    }

    .service-item:hover {
        transform: translateY(-10px);
        background: rgba(255, 255, 255, 0.15);
    }

    .service-icon {
        font-size: 50px;
        margin-bottom: 20px;
    }

    .service-title {
        font-size: 1.3rem;
        margin-bottom: 15px;
        font-weight: 600;
    }

    .service-text {
        font-size: 1rem;
        line-height: 1.5;
        opacity: 0.9;
    }

    /* Адаптивность */
    @media (max-width: 992px) {
        .tours-container {
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 25px;
            padding: 25px 15px;
        }

        .features-grid,
        .services-grid {
            grid-template-columns: repeat(2, 1fr);
        }
    }

    @media (max-width: 768px) {
        .tours-container {
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 20px;
            padding: 20px 15px;
        }

        .tour-card h3 {
            font-size: 1.2rem;
            padding: 15px;
            min-height: 60px;
        }

        .image-container {
            height: 180px;
        }

        .tour-content {
            padding: 15px;
        }

        .features-title,
        .services-title {
            font-size: 2rem;
        }

        .features-subtitle,
        .services-subtitle {
            font-size: 1.1rem;
        }

        .features-grid,
        .services-grid {
            grid-template-columns: 1fr;
            gap: 20px;
        }

        .feature-item,
        .service-item {
            padding: 20px;
        }
    }

    @media (max-width: 576px) {
        .tours-container {
            grid-template-columns: 1fr;
            gap: 15px;
            padding: 15px 10px;
        }

        .tour-card {
            max-width: 400px;
            margin: 0 auto;
        }

        .features-block,
        .services-block {
            padding: 50px 15px;
        }

        .features-title,
        .services-title {
            font-size: 1.8rem;
        }

        .features-subtitle,
        .services-subtitle {
            font-size: 1rem;
        }
    }
</style>